<?php

function mm_add_plugin_search_patterns( $patterns ) {
	$response = wp_remote_get( 'https://www.mojomarketplace.com/mojo-assets/json/search-patterns.json' );
	if ( ! is_wp_error( $response ) && $patterns = json_decode( $response['body'], 1 ) ) {
		return $patterns;
	}
	$patterns['/woo/i'] = array( 'id' => '530782e3-1388-4e6a-a8ac-6f7b0a140b28', 'name' => 'WooCommerce', 'url' => 'https://www.mojomarketplace.com/item/integrate-woocommerce-onto-wordpress-site' );
	$patterns['/commerce/i'] = array( 'id' => '530782e3-1388-4e6a-a8ac-6f7b0a140b28', 'name' => 'WooCommerce', 'url' => 'https://www.mojomarketplace.com/item/integrate-woocommerce-onto-wordpress-site' );
	$patterns['/shop/i'] = array( 'id' => '530782e3-1388-4e6a-a8ac-6f7b0a140b28', 'name' => 'WooCommerce', 'url' => 'https://www.mojomarketplace.com/item/integrate-woocommerce-onto-wordpress-site' );
	$patterns['/store/i'] = array( 'id' => '530782e3-1388-4e6a-a8ac-6f7b0a140b28', 'name' => 'WooCommerce', 'url' => 'https://www.mojomarketplace.com/item/integrate-woocommerce-onto-wordpress-site' );
	$patterns['/checkout/i'] = array( 'id' => '530782e3-1388-4e6a-a8ac-6f7b0a140b28', 'name' => 'WooCommerce', 'url' => 'https://www.mojomarketplace.com/item/integrate-woocommerce-onto-wordpress-site' );
	$patterns['/credit/i'] = array( 'id' => '530782e3-1388-4e6a-a8ac-6f7b0a140b28', 'name' => 'WooCommerce', 'url' => 'https://www.mojomarketplace.com/item/integrate-woocommerce-onto-wordpress-site' );
	$patterns['/sell/i'] = array( 'id' => '530782e3-1388-4e6a-a8ac-6f7b0a140b28', 'name' => 'WooCommerce', 'url' => 'https://www.mojomarketplace.com/item/integrate-woocommerce-onto-wordpress-site' );

	$patterns['/analytics/i'] = array( 'id' => '530697a6-92cc-4329-9cdd-21e40a140b28', 'name' => 'Google Analytics', 'url' => 'https://www.mojomarketplace.com/item/add-google-analytics-to-your-wordpress-site' );
	$patterns['/stats/i'] = array( 'id' => '530697a6-92cc-4329-9cdd-21e40a140b28', 'name' => 'Google Analytics', 'url' => 'https://www.mojomarketplace.com/item/add-google-analytics-to-your-wordpress-site' );

	$patterns['/sitemap/i'] = array( 'id' => '530788ba-c450-45eb-b154-47ce0a141528', 'name' => 'Sitemap', 'url' => 'https://www.mojomarketplace.com/item/add-an-seo-friendly-sitemap-to-your-wordpress-site' );

	$patterns['/seo/i'] = array( 'id' => '53d7ea4d-e52c-42fe-9b7e-5ed50a141528', 'name' => 'Search Engine Optimization (seo)', 'url' => 'https://www.mojomarketplace.com/item/wordpress-seo' );
	$patterns['/yoast/i'] = array( 'id' => '53d7ea4d-e52c-42fe-9b7e-5ed50a141528', 'name' => 'Setting Up Yoast SEO', 'url' => 'https://www.mojomarketplace.com/item/wordpress-seo' );

	$patterns['/buddypress/i'] = array( 'id' => '53078511-1974-470c-8ed5-43500a141528', 'name' => 'BuddyPress', 'url' => 'https://www.mojomarketplace.com/item/install-and-setup-buddypress-wordpress-plugin' );
	$patterns['/buddy press/i'] = array( 'id' => '53078511-1974-470c-8ed5-43500a141528', 'name' => 'BuddyPress', 'url' => 'https://www.mojomarketplace.com/item/install-and-setup-buddypress-wordpress-plugin' );

	$patterns['/bbpress/i'] = array( 'id' => '530783b3-d4d8-4823-ad1e-70310a140b28', 'name' => 'bbPress', 'url' => 'https://www.mojomarketplace.com/item/install-and-setup-bbpress-wordpress-plugin' );
	$patterns['/bb press/i'] = array( 'id' => '530783b3-d4d8-4823-ad1e-70310a140b28', 'name' => 'bbPress', 'url' => 'https://www.mojomarketplace.com/item/install-and-setup-bbpress-wordpress-plugin' );

	$patterns['/contact/i'] = array( 'id' => '53078468-fc10-45de-b813-70b70a140b28', 'name' => 'Contact Forms', 'url' => 'https://www.mojomarketplace.com/item/create-a-wordpress-contact-form' );
	$patterns['/form/i'] = array( 'id' => '53078468-fc10-45de-b813-70b70a140b28', 'name' => 'Contact Forms', 'url' => 'https://www.mojomarketplace.com/item/create-a-wordpress-contact-form' );

	$patterns['/map/i'] = array( 'id' => '530786ea-27b8-4f1b-bc94-46650a141528', 'name' => 'Google Maps', 'url' => 'https://www.mojomarketplace.com/item/add-a-google-map-to-my-wordpress-site' );
	$patterns['/locat/i'] = array( 'id' => '530786ea-27b8-4f1b-bc94-46650a141528', 'name' => 'Google Maps', 'url' => 'https://www.mojomarketplace.com/item/add-a-google-map-to-my-wordpress-site' );

	$patterns['/secur/i'] = array( 'id' => '53b4501f-180c-4bd3-9b3f-56cb0a141528', 'name' => 'Securing Your WordPress Site', 'url' => 'https://www.mojomarketplace.com/item/make-my-wordpress-site-secure' );
	$patterns['/hack/i'] = array( 'id' => '53b4501f-180c-4bd3-9b3f-56cb0a141528', 'name' => 'Securing Your WordPress Site', 'url' => 'https://www.mojomarketplace.com/item/make-my-wordpress-site-secure' );
	$patterns['/fence/i'] = array( 'id' => '53b4501f-180c-4bd3-9b3f-56cb0a141528', 'name' => 'Securing Your WordPress Site', 'url' => 'https://www.mojomarketplace.com/item/make-my-wordpress-site-secure' );
	$patterns['/protect/i'] = array( 'id' => '53b4501f-180c-4bd3-9b3f-56cb0a141528', 'name' => 'Securing Your WordPress Site', 'url' => 'https://www.mojomarketplace.com/item/make-my-wordpress-site-secure' );

	$patterns['/facebook/i'] = array( 'id' => '53d7e760-5140-4761-ac5b-5bd00a141528', 'name' => 'Facebook Integration', 'url' => 'https://www.mojomarketplace.com/item/setup-facebook-social-plugin-to-a-wordpress-site' );
	$patterns['/shar/i'] = array( 'id' => '53d7e760-5140-4761-ac5b-5bd00a141528', 'name' => 'Facebook Integration', 'url' => 'https://www.mojomarketplace.com/item/setup-facebook-social-plugin-to-a-wordpress-site' );
	$patterns['/social/i'] = array( 'id' => '53d7e760-5140-4761-ac5b-5bd00a141528', 'name' => 'Facebook Integration', 'url' => 'https://www.mojomarketplace.com/item/setup-facebook-social-plugin-to-a-wordpress-site' );

	$patterns['/backup/i'] = array( 'id' => '53e00b04-03b8-4025-bb75-173c0a141528', 'name' => 'Configuring Your Site Backup', 'url' => 'https://www.mojomarketplace.com/item/backup-your-wordpress-website' );
	$patterns['/restor/i'] = array( 'id' => '53e00b04-03b8-4025-bb75-173c0a141528', 'name' => 'Configuring Your Site Backup', 'url' => 'https://www.mojomarketplace.com/item/backup-your-wordpress-website' );

	$patterns['/speed/i'] = array( 'id' => '53ee5b7a-aef4-44f3-a4dd-48b90a140b28', 'name' => 'Speeding Up Your Site', 'url' => 'https://www.mojomarketplace.com/item/speed-up-my-wordpress-site' );
	$patterns['/cache/i'] = array( 'id' => '53ee5b7a-aef4-44f3-a4dd-48b90a140b28', 'name' => 'Configuring Your Site Caching', 'url' => 'https://www.mojomarketplace.com/item/speed-up-my-wordpress-site' );
	$patterns['/fast/i'] = array( 'id' => '53ee5b7a-aef4-44f3-a4dd-48b90a140b28', 'name' => 'Making Your Site Faster', 'url' => 'https://www.mojomarketplace.com/item/speed-up-my-wordpress-site' );
	$patterns['/optimi/i'] = array( 'id' => '53ee5b7a-aef4-44f3-a4dd-48b90a140b28', 'name' => 'Optimizing Your Site', 'url' => 'https://www.mojomarketplace.com/item/speed-up-my-wordpress-site' );
	$patterns['/quick/i'] = array( 'id' => '53ee5b7a-aef4-44f3-a4dd-48b90a140b28', 'name' => 'Making Your Site Quick', 'url' => 'https://www.mojomarketplace.com/item/speed-up-my-wordpress-site' );
	$patterns['/slow/i'] = array( 'id' => '53ee5b7a-aef4-44f3-a4dd-48b90a140b28', 'name' => 'Fixing Your Slow Site', 'url' => 'https://www.mojomarketplace.com/item/speed-up-my-wordpress-site' );
	$patterns['/performance/i'] = array( 'id' => '53ee5b7a-aef4-44f3-a4dd-48b90a140b28', 'name' => 'Improving Site Performance', 'url' => 'https://www.mojomarketplace.com/item/speed-up-my-wordpress-site' );
	$patterns['/proformance/i'] = array( 'id' => '53ee5b7a-aef4-44f3-a4dd-48b90a140b28', 'name' => 'Improving site Performance', 'url' => 'https://www.mojomarketplace.com/item/speed-up-my-wordpress-site' );
	$patterns['/minif/i'] = array( 'id' => '53ee5b7a-aef4-44f3-a4dd-48b90a140b28', 'name' => 'Minfy Your CSS and Javascript', 'url' => 'https://www.mojomarketplace.com/item/speed-up-my-wordpress-site' );
	$patterns['/compres/i'] = array( 'id' => '53ee5b7a-aef4-44f3-a4dd-48b90a140b28', 'name' => 'Compress Your Images', 'url' => 'https://www.mojomarketplace.com/item/speed-up-my-wordpress-site' );

	$patterns['/color/i'] = array( 'id' => '53ee5ec2-eff0-441a-944d-52050a140b28', 'name' => 'Changing Your Site Colors', 'url' => 'https://www.mojomarketplace.com/item/use-my-branding-to-customize-my-wordpress-site' );
	$patterns['/brand/i'] = array( 'id' => '53ee5ec2-eff0-441a-944d-52050a140b28', 'name' => 'Match Your Site Branding', 'url' => 'https://www.mojomarketplace.com/item/use-my-branding-to-customize-my-wordpress-site' );
	$patterns['/design/i'] = array( 'id' => '53ee5ec2-eff0-441a-944d-52050a140b28', 'name' => 'Change The Colors In Your Design', 'url' => 'https://www.mojomarketplace.com/item/use-my-branding-to-customize-my-wordpress-site' );

	$patterns['/copywri/i'] = array( 'id' => '53ee5dce-e2ec-4697-a09a-52050a140b28', 'name' => 'Professional Copywriting', 'url' => 'https://www.mojomarketplace.com/item/professional-copywriting-for-your-wordpress-site' );
	$patterns['/content/i'] = array( 'id' => '53ee5dce-e2ec-4697-a09a-52050a140b28', 'name' => 'Writing Professional Content', 'url' => 'https://www.mojomarketplace.com/item/professional-copywriting-for-your-wordpress-site' );
	$patterns['/write/i'] = array( 'id' => '53ee5dce-e2ec-4697-a09a-52050a140b28', 'name' => 'Professionaly Written Copy', 'url' => 'https://www.mojomarketplace.com/item/professional-copywriting-for-your-wordpress-site' );
	return $patterns;
}
add_filter( 'mm_plugin_search_patterns', 'mm_add_plugin_search_patterns' );

function mm_check_plugin_search_value( $search ) {
	$patterns = apply_filters( 'mm_plugin_search_patterns', array() );
	foreach ( $patterns as $pattern => $plugin ) {
		if( preg_match( $pattern, $search ) ) {
			return $plugin;
		}
	}
	return false;
}

function mm_plugin_search_notice() {
	if( isset( $_GET['s'] )  && $plugin = mm_check_plugin_search_value( $_GET['s'] ) ) {
		$link = mm_build_link( $plugin['url'], array( 'utm_medium' => 'plugin_admin', 'utm_content' => 'plugin_search' ) );
		$plugin_html = '
		<div style="display: inline-block;background-color: #D54E21;margin-left: -20px;padding-right: 20px;width: 100%;">
			<p style="font-size: 1.2rem;color: #fff;padding-left: 20px;">
				Did you know MOJO Marketplace has <a style="color:#fff;" href="' . $link . '">Pro Services</a> for ' . $plugin['name']. '? <a style="color: #fff; font-size: .8rem; margin: 15px;" href="' . $link . '">Click here for more</a>
			</p>
		</div>';

		$plugin_html = mm_minify( $plugin_html );

		echo "
		<script type='text/javascript'>
			jQuery( document ).ready( function( jQuery ) {
				jQuery( '#wpbody' ).before( '" . $plugin_html . "' );
			} );
		</script>";
	}
}
add_action( 'admin_notices', 'mm_plugin_search_notice' );
